const authentocator = (roles) => {
  return (req, res, next) => {
    if (!Array.isArray(roles)) {
      roles = [roles];
    }
    const userRole = req.session.user.userRole;
    if (roles.includes(userRole)) {
      return next();
    } else {
      return res.redirect('/logout');
    }
  };
};

const login_checker = (req, res, next) => {
    if(!req.session.user){
        return res.redirect('/logout');
    }else{
        next();
    }
};

module.exports = {authentocator, login_checker};