const express = require('express');
const router = express.Router();
const adminController = require('../controllers/adminController');
const { authentocator } = require('../globalMiddleware/auth');
const user_role = {admin:1};

router.use(express.urlencoded({ extended: true })); /*/ Parse URL-encoded bodies*/
router.use(express.json());

// *  CSV management routes
router.use("/csvManagement", authentocator(user_role.admin), (req, res)=> {
    return res.render("csv-listing", { active : "CsvManagement"});
})

// *

// **  Product management routes
router.route("/productManagement")
    .all(authentocator(user_role.admin))
    .get(adminController.fetchAllProducts)
    .post(adminController.upsertProducts);

router.post('/checkProductExistence', authentocator(user_role.admin), adminController.checkProductExist);

router.post("/deleteProduct", authentocator(user_role.admin), adminController.deleteProduct);
// **

// ** default route
router.use("/", authentocator(user_role.admin), (req, res)=> {
    return res.render("csv-listing", { active : "CsvManagement"});
})
//
module.exports = router;